setwd("<your path here>")
df1 <- read.csv("20191121 Example 17.3 accelerated life test data.csv")

attach(df1)


# inputs:
# Test = index
# TempC = test temp in oC
# Time = test time in hours
# n = number of units on test
# s = number surviving units after test
#
# the R function "log" is the natural logarithm
#
TK1 <- TempC[1] + 273
TK2 <- TempC[2] + 273
n1 <- n[1]
n2 <- n[2]
s1 <- s[1]
s2 <- s[2]

lnA <- (TK2)/(TK2 - TK1)*(log(-log(s2/n2)) + TK1*log(-log(s1/n1))/TK2 + log(Time))
B <- TK1*(lnA - log(-log(s1/n1)) + log(Time))
k <- exp(-B/TK2) / exp(-B/TK1)
Sim.Time <- 17532 #this is the desired time to simulate
k.targ <- Sim.Time/720 #this is the required acceleration, based on an actual test time of 720
Ptarg <- B[1]*TK1/(B[1]-TK1*log(k.targ))#this is the temperature required for the test
lamda <- (exp(lnA[1])*exp(-B[1]/Ptarg))/k.targ #this is the estimate of the failure rate at nominal temp
rel.P0 <- exp(-lamda*Sim.Time)#this is the estimated reliability at nominal temp over Sim.Time time units

df2 <- cbind(lnA,B,k,Ptarg,Sim.Time,lamda,rel.P0)

write.csv(df2,file="20191121.acceleration.parameters.csv")



